#include <stdio.h>
#include <stdlib.h>
#include "platform.h"
#include "xparameters.h"
#include "xgpio.h"
#include "xgpiops.h" // for PS GPIO(MIO)
#include "xil_cache.h"

// yz
// n[hEFA@foȌݎ菇
// (1) {[hZbg(ZedBoard:PS-RST,ZYBO:PS-SRST)
// (2) Vivado  Program Device
// (3) SDK  Run As Hardware
// (4) Vivado  Reflesh device

/* Write Port 0 (AXI Lite -> Direct -> AXIS Master 0) */
/* Write Port 1 (AXI Lite ->  FIFO  -> AXIS Master 1) */
/* Read  Port 0 (AXI Lite <- Direct <- AXIS Slave  0) */
/* Read  Port 1 (AXI Lite <-  FIFO  <- AXIS Slave  1) */
volatile unsigned int *w0data_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x00;
volatile unsigned int *w0busy_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x04;
volatile unsigned int *w0avail_p=XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x08;
volatile unsigned int *w1data_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x10;
volatile unsigned int *w1busy_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x14;
volatile unsigned int *w1avail_p=XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x18;
volatile unsigned int *r0data_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x20;
volatile unsigned int *r0busy_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x24;
volatile unsigned int *r0avail_p=XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x28;
volatile unsigned int *r1data_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x30;
volatile unsigned int *r1busy_p =XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x34;
volatile unsigned int *r1avail_p=XPAR_RIZM_AXILITE_FIFO_0_BASEADDR+0x38;

volatile unsigned int *gpio0_p=XPAR_AXI_GPIO_0_BASEADDR+XGPIO_DATA_OFFSET;
volatile unsigned int *gpio1_p=XPAR_AXI_GPIO_0_BASEADDR+XGPIO_DATA2_OFFSET;

#define LED_PIN 7
#define PB1_PIN 50
#define PB2_PIN 51
static XGpioPs gpiops;

int main(){
  static XGpioPs_Config* gpiops_config_ptr;
  int pb1,pb2,pb1_prev,pb2_prev,led;
  int pl_btn,pl_sw,pl_btn_prev,pl_btn2;
  int counter;
  int r;
  char c;
  init_platform();
  Xil_ICacheEnable();
  Xil_DCacheEnable();
  
  print("psloopback.c: ");
  print(__TIMESTAMP__);
  print("\r\n");
  
  gpiops_config_ptr=XGpioPs_LookupConfig(XPAR_XGPIOPS_0_DEVICE_ID);
  r=XGpioPs_CfgInitialize(&gpiops,gpiops_config_ptr,gpiops_config_ptr->BaseAddr);
  if(r!=XST_SUCCESS) {
    print( "GPIOps Init Err\n\r");
    exit(-1);
  }
  XGpioPs_SetDirectionPin   (&gpiops,LED_PIN,1);
  XGpioPs_SetDirectionPin   (&gpiops,PB1_PIN,0);
  XGpioPs_SetDirectionPin   (&gpiops,PB2_PIN,0);
  XGpioPs_SetOutputEnablePin(&gpiops,LED_PIN,1);
  XGpioPs_SetOutputEnablePin(&gpiops,PB1_PIN,0);
  XGpioPs_SetOutputEnablePin(&gpiops,PB2_PIN,0);
  
  pb1_prev=XGpioPs_ReadPin(&gpiops,PB1_PIN);
  pb2_prev=XGpioPs_ReadPin(&gpiops,PB2_PIN);
  pl_btn_prev=(*gpio0_p);
  counter=0;
  while(1){
    pb1=XGpioPs_ReadPin(&gpiops,PB1_PIN);
    pb2=XGpioPs_ReadPin(&gpiops,PB2_PIN);
    led=(counter&0x1)?1:0;
    XGpioPs_WritePin(&gpiops,LED_PIN,led);
    pl_btn=(*gpio0_p);
    pl_sw =(*gpio1_p);

    scanf("%c",&c);
    if (c>='a'&&c<'z') {
      c=c-'a'+'A';
    } else if (c>='A'&&c<'Z') {
      c=c-'A'+'a';
    }
    printf("%c",c);

    counter++;
    pb1_prev=pb1;
    pb2_prev=pb2;
    pl_btn_prev=pl_btn;
  }
  
  print("Exit Main\n");
  Xil_DCacheDisable();
  Xil_ICacheDisable();
  
  
  cleanup_platform();
  return 0;
}
