/*
 (C) Tomonori Izumi <izumi@ieee.org>, Sep. 2015. All rigts reserved.
 for xc7z020clg484-1 on Digilent ZYBO
 					Ver.2015.09.28a
*/
 
 //`timescale 1ns / 1ps
`default_nettype none

module ZYBO_top
  (CLK125M,btn,sw,led,
   DDR_addr, DDR_ba, DDR_cas_n, DDR_ck_n, DDR_ck_p, DDR_cke, DDR_cs_n, DDR_dm,
   DDR_dq, DDR_dqs_n, DDR_dqs_p, DDR_odt, DDR_ras_n, DDR_reset_n, DDR_we_n,
   FIXED_IO_ddr_vrn, FIXED_IO_ddr_vrp, FIXED_IO_mio, FIXED_IO_ps_clk,
   FIXED_IO_ps_porb, FIXED_IO_ps_srstb,
   je0,je1,je2,je3,je4,je5,je6,je7);
   input  CLK125M;
   input [3:0] btn;
   input [3:0] sw;
   output [3:0] led;
   inout 	je0,je1,je2,je3,je4,je5,je6,je7; // Pmod JE
   inout [14:0] DDR_addr;
   inout [2:0] 	DDR_ba;
   inout 	DDR_cas_n;
   inout 	DDR_ck_n;
   inout 	DDR_ck_p;
   inout 	DDR_cke;
   inout 	DDR_cs_n;
   inout [3:0] 	DDR_dm;
   inout [31:0] DDR_dq;
   inout [3:0] 	DDR_dqs_n;
   inout [3:0] 	DDR_dqs_p;
   inout 	DDR_odt;
   inout 	DDR_ras_n;
   inout 	DDR_reset_n;
   inout 	DDR_we_n;
   inout 	FIXED_IO_ddr_vrn;
   inout 	FIXED_IO_ddr_vrp;
   inout [53:0] FIXED_IO_mio;
   inout 	FIXED_IO_ps_clk;
   inout 	FIXED_IO_ps_porb;
   inout 	FIXED_IO_ps_srstb;
   
   wire 	CLK125M_ibuf,clk0;
   IBUFG ibuf_clk(.I(CLK125M), .O(CLK125M_ibuf));
   BUFG  buf_clk(.I(CLK125M_ibuf),.O(clk0));

   wire 	clk;
   wire 	rstn;

   //----------------------------------------------------------------
   // setup : ARM Ƃ̐ڑBNbNƃZbg͂ɈˑB

   wire 	arm_clko;
   wire 	arm_rstno;
   wire [31:0] 	arm_gpi0;
   wire [31:0] 	arm_gpi1;
   wire [31:0] 	arm_gpo0;
   wire [31:0] 	arm_gpo1;
   (* mark_debug = "true" *) wire [7:0] arm_m0data, arm_s0data;
   (* mark_debug = "true" *) wire 	arm_m0valid,arm_s0valid,arm_m0ready,arm_s0ready;
   (* mark_debug = "true" *) wire [7:0] arm_m1data, arm_s1data;
   (* mark_debug = "true" *) wire 	arm_m1valid,arm_s1valid,arm_m1ready,arm_s1ready;
   
   //assign 	clk=clk0;
   //assign 	rstn=1;

   assign 	clk=arm_clko;
   assign 	rstn=arm_rstno;

  Zynq_PS Zynq_PS_i
     (.DDR_addr(DDR_addr),
      .DDR_ba(DDR_ba),
      .DDR_cas_n(DDR_cas_n),
      .DDR_ck_n(DDR_ck_n),
      .DDR_ck_p(DDR_ck_p),
      .DDR_cke(DDR_cke),
      .DDR_cs_n(DDR_cs_n),
      .DDR_dm(DDR_dm),
      .DDR_dq(DDR_dq),
      .DDR_dqs_n(DDR_dqs_n),
      .DDR_dqs_p(DDR_dqs_p),
      .DDR_odt(DDR_odt),
      .DDR_ras_n(DDR_ras_n),
      .DDR_reset_n(DDR_reset_n),
      .DDR_we_n(DDR_we_n),
      .FIXED_IO_ddr_vrn(FIXED_IO_ddr_vrn),
      .FIXED_IO_ddr_vrp(FIXED_IO_ddr_vrp),
      .FIXED_IO_mio(FIXED_IO_mio),
      .FIXED_IO_ps_clk(FIXED_IO_ps_clk),
      .FIXED_IO_ps_porb(FIXED_IO_ps_porb),
      .FIXED_IO_ps_srstb(FIXED_IO_ps_srstb),
      .clk_out(arm_clko),
      .gpi0(arm_gpi0),
      .gpi1(arm_gpi1),
      .gpo0(arm_gpo0),
      .gpo1(arm_gpo1),
      .m0_axis_tdata( arm_m0data),
      .m0_axis_tvalid(arm_m0valid),
      .m0_axis_tready(arm_m0ready),
      .m1_axis_tdata( arm_m1data),
      .m1_axis_tvalid(arm_m1valid),
      .m1_axis_tready(arm_m1ready),
      .s0_axis_tdata( arm_s0data),
      .s0_axis_tvalid(arm_s0valid),
      .s0_axis_tready(arm_s0ready),
      .s1_axis_tdata( arm_s1data),
      .s1_axis_tvalid(arm_s1valid),
      .s1_axis_tready(arm_s1ready),
      .resetn_out(arm_rstno));
   

   // loopback for AXIS_M0,AXIS_S0
   // ARM -> AXI Lite Slave [axilite_fifo] -> AXIS Master0 -> lb
   // ARM <- AXI Lite Slave [axilite_fifo] -> AXIS Slave0  <- lb
   reg [3:0] 	arm_lb0data_r=0;
   reg 		arm_lb0valid_r=0;
   parameter 	AXIS_LB_THROUGH=0;
   assign 	arm_m0ready=(AXIS_LB_THROUGH)?1:~arm_lb0valid_r;
   assign 	arm_s0valid=(AXIS_LB_THROUGH)?1: arm_lb0valid_r;
   assign 	arm_s0data = arm_lb0data_r+sw_r;
   always @(posedge clk)
     if (!rstn) begin
	arm_lb0data_r <=0;
	arm_lb0valid_r<=0;
     end else if (arm_m0valid&arm_m0ready) begin
	arm_lb0data_r<=arm_m0data;
	arm_lb0valid_r<=1;
     end else if (arm_s0valid&arm_s0ready) begin
	arm_lb0valid_r<=0;
     end
   
   //----------------------------------------------------------------
   // setup : ėpJE^Ɠ̓`^O΍Ao
   // cNbN PLnclk0PSnclk̂Qn
   
   reg [31:0] 	counter0=0;
   always @(posedge clk0)  // on board clock
     counter0<=counter0+1;

   (* mark_debug = "true" *) reg [31:0] 	counter=0;
   always @(posedge clk)   // on processor clock
     if (!rstn) counter<=0;
     else counter<=counter+1;
   
   reg [3:0] 	led_r;
   reg [3:0] 	sw_r;
   reg [3:0] 	btn_r;
   
   always @(posedge clk)   // on processor clock
     if (counter[15:0]==0) begin
	sw_r  <=sw;
	btn_r<=btn;
     end
   
   assign led=led_r;
   
   //----------------------------------------------------------------
   // setup : extra UART PL - PC (without PS)
   
   wire   UARTRX,UARTTX;
   wire [7:0] uartrxdata;
   wire [7:0] uarttxdata;
   wire       uartrxwait,  uarttxvalid;
   wire       uartrxvalid, uarttxwait;
   defparam uartrx.PULSEW  = 868; // 100MHz/115200bps=868
   defparam uartrx.PULSEW2 = 434; // PULSEW/2
   UART_RX_module uartrx(UARTRX,uartrxdata,uartrxvalid,uartrxwait,clk,rstn);
   defparam uarttx.PULSEW  = 868; // 100MHz/115200bps=868
   defparam uarttx.PULSEW2 = 434; // PULSEW/2
   UART_TX_module uarttx(uarttxdata,uarttxvalid,uarttxwait,UARTTX,clk,rstn);

   // transmit/receive data counter for debug
   reg [7:0]   uartrxcount, uarttxcount;
   always @(posedge clk)
     if (!rstn) begin
	uartrxcount<=0;
	uarttxcount<=0;
     end else begin
	if (uartrxvalid&~uartrxwait) begin
	   uartrxcount<=uartrxcount+1;
	end
	if (uarttxvalid&~uarttxwait) begin
	   uarttxcount<=uarttxcount+1;
	end
     end

   // UARTRX -> AXIS Slave1  [axilite_fifo] -> AXI-Lite -> ARM
   assign arm_s1data = uartrxdata;
   assign arm_s1valid= uartrxvalid;
   assign uartrxwait =~arm_s1ready;
   
   // UARTTX <- AXIS Master1 [axilite_fifo] <- AXI-Lite <- ARM
   assign uarttxdata = arm_m1data;
   assign uarttxvalid= arm_m1valid;
   assign arm_m1ready=~uarttxwait;

   //----------------------------------------------------------------
   // setup : LED \ݒ

   assign 	arm_gpi0={28'b0,btn_r};
   assign 	arm_gpi1={28'b0,sw_r};
   
   //----------------------------------------------------------------
   // setup : LED \ݒ

   always @(posedge clk)
     case (btn_r)
       4'b0001: led_r<=arm_gpo0[3:0];
       4'b0010: led_r<=counter[27:24];
       4'b0100: led_r<=arm_gpo1[7:4];
       4'b1000: led_r<=counter[31:28];
       default: led_r<=arm_lb0data_r;
     endcase // case(btn_r)

   //----------------------------------------------------------------
   // setup : ėpo̓s̐ڑ

   assign 	je0 =1'bz;
   assign 	je1 =1'bz;
   assign 	je2 = UARTTX; //assign je2 =1'bz;
   assign 	UARTRX = je3; //assign je3 =1'bz;
   assign 	je4 =1'bz;
   assign 	je5 =1'bz;
   assign 	je6 =1'bz;
   assign 	je7 =1'bz;
   
endmodule

// [Synth 8-3331] unconnected port
// [Synth 8-3848] does not have driver
// [Synth 8-3295] tying undriven pin to constant
