//
// example code for async read/write of stdin/out <-> com port
//

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <windows.h> // for Windows API GetAsyncKeyState()

/*
  gcc -O -Wall -g hoge.c -o hoge.exe -mwindows
*/

#define ComPortNo 20

#define BUFSIZE 256
static char buf[BUFSIZE];

// memo : configuration of com port on windows
// mode.com com1: BAUD=9600 PARITY=N DATA=8 STOP=1 to=off xon=off odsr=off octs=on dtr=off rts=on idsr=off


int UART_Init(int p){
  static int fd;
  static struct termios term;
  sprintf(buf,"/dev/ttyS%d",p-1); // example COM1 -> /dev/ttyS0
  fd = open(buf,O_RDWR);
  if(fd<0){
    fprintf(stderr,"COM%d OPEN ERROR\n",p);
    exit(1);
  }

  tcgetattr(fd,&term);
  /* flag &=~(a|b|..|z) ... disables the listed properties */
  /* flag |=  a|b|..|z  ... enables the listed properties */
  term.c_iflag &= ~(IGNBRK|BRKINT|PARMRK|ISTRIP|INLCR|IGNCR|ICRNL|IXON|IXOFF);
  term.c_cflag &= ~(CSIZE|CSTOPB|PARENB);
  term.c_cflag |= CS8;
  term.c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG|IEXTEN);
  term.c_cc[VMIN]=0;
  term.c_cc[VTIME]=1;
  cfsetispeed(&term,B115200); //B115200
  cfsetospeed(&term,B115200);

  tcflush(fd,TCIFLUSH);
  tcsetattr(fd,TCSANOW,&term);

  return fd;
}


/*----------------------------------------------------------------*/

int main(int argc, char **argv){
  int portnum = ComPortNo;
  int n;
  time_t t;
  
  if (argc>=2) portnum=atoi(argv[1]);
  int fd = UART_Init(portnum);
  sleep(1);

  while (1) {
        // read from key or button
    int BtnL = (GetAsyncKeyState(VK_LBUTTON)&0x8000)?1:0;
    int BtnR = (GetAsyncKeyState(VK_RBUTTON)&0x8000)?1:0;
    printf("MouseButton=%d%d ",BtnL,BtnR);
    
    // write to uart
    buf[0]=(BtnL||BtnR)?1:0;
    write(fd,buf,1);
    printf("Write>UART %x ",buf[0]);
    
    // read uart
    n=read(fd,buf,BUFSIZE-1); //non-blocking, multi-bytes
    if (n<0) {
      fprintf(stderr,"read error\n");
      exit(1);
    }
    printf("Read<UART ");
    for (int i=0;i<n;i++) printf("%x ",buf[i]);

    time(&t);
    printf("time %s ",ctime(&t));

    usleep(500000);
  }

  return 0;
}




