#include "mini4WD2.h"
#include "soundcode.h"

void setup() {
  pinMode(PinLD, OUTPUT);
  pinMode(PinLD2,OUTPUT);
  pinMode(PinBZ, OUTPUT);
  pinMode(PinMTR,OUTPUT);
  pinMode(PinBRK,OUTPUT);
  pinMode(PinMTR,OUTPUT);
  pinMode(PinBTN,INPUT);
  pinMode(PinSL, INPUT);
  pinMode(PinSL2,INPUT);

  digitalWrite(PinBRK,0);
  digitalWrite(PinMTR,1);
  Serial.begin(115200);
  randomSeed(analogRead(PinPD));
  
  soundcode_pin   = 11;
  soundcode_tempo = 25;
  soundcode_play(soundcode_f1gp);
  delay(2000);
}

void loop() {
  int i;
  Serial.print("\012\012ACCEL->SHORT BRAKE\015");
  soundcode_playword(0x40700900);
  Serial.print("\012BRK0 MTR0 ACCEL\015");
  digitalWrite(PinBRK,0);
  digitalWrite(PinMTR,0);
  delay(2000);
  Serial.print("\012BRK1 MTR1 BRAKE\015");
  digitalWrite(PinBRK,1);
  digitalWrite(PinMTR,1);
  delay(2000);
  Serial.print("\012BRK0 MTR1 STOP\015");
  digitalWrite(PinBRK,0);
  digitalWrite(PinMTR,1);
  delay(2000);

  Serial.print("\012\012ACCEL -> STOP\015");
  soundcode_playword(0x40700eee);
  Serial.print("\012BRK0 MTR0 ACCEL\015");
  digitalWrite(PinBRK,0);
  digitalWrite(PinMTR,0);
  delay(2000);
  Serial.print("\012BRK0 MTR1 STOP\015");
  digitalWrite(PinBRK,0);
  digitalWrite(PinMTR,1);
  delay(2000);

  Serial.print("\012\012GRAD ACCEL -> GRAD STOP\015");
  soundcode_playword(0x40222eee);
  Serial.print("\012MTR255->0 SPEED UP\015");
  for (i=255;i>=0;i--){
    analogWrite(PinMTR,i);
    delay(20);
  }
  delay(1000);
  Serial.print("\012MTR0->255 SPEED DOWN\015");
  for (i=0;i<=255;i++){
    analogWrite(PinMTR,i);
    delay(20);
  }
  delay(1000);

  Serial.print("\012BRK0 MTR1 STOP\015");
  digitalWrite(PinBRK, 0);
  digitalWrite(PinMTR, 1);
  delay(1000);
}
