/*
  SparkFun IMU Breakout - MPU-9250(+AK8963)
  I2C connected to A4(SDA)&A5(SCL)
*/

#include <Wire.h>
#include "mini4WD2.h"
#include "mini4WD2packet.h"
#include "soundcode.h"

unsigned char run=0;
unsigned char status=0,brk=0,mtr=255;
unsigned long period=1000000; /* micro seconds */
unsigned long t0,t1;

struct ctrlpacket_struct cpkt;
struct senspacket_struct spkt;
unsigned char spkt_ready=0;

#define I2CAG 0x68
#define I2CM  0x0c
#define I2CTIMEOUTus  20
#define I2CTIMEOUTnum  5
#define I2CBUFSZ 16
unsigned char i2cbuf[I2CBUFSZ];

unsigned char led=0;

#define SNDERR01 0x40b
#define SNDERR02 0x40b0
#define SNDERR03 0x40b00
#define SNDERR04 0x40b000
#define SNDERR05 0x40b0000
#define SNDERR06 0x40b00000
#define SNDERR07 0x40bd
#define SNDERR08 0x40bdc

unsigned char I2CRead(int dadr, int radr){
  int t=I2CTIMEOUTnum;
  Wire.beginTransmission(dadr);
  Wire.write(radr);
  Wire.endTransmission(false);
  Wire.requestFrom(dadr,1);
  while (!Wire.available()) {
    delayMicroseconds(I2CTIMEOUTus);
    if (t--<=0) return 0xff;
  }
  return Wire.read();
}

int I2CReadN(int dadr, int radr, unsigned char *buf, int n){
  int i=0,t=I2CTIMEOUTnum;
  if (n<=0) goto _RETURN;
  Wire.beginTransmission(dadr);
  Wire.write(radr);
  Wire.endTransmission(false);
  Wire.requestFrom(dadr,n);
  while (i<n) {
    while (!Wire.available()) {
      delayMicroseconds(I2CTIMEOUTus);
      if (t--<=0) goto _RETURN;
    }
    buf[i++]=Wire.read();
  }
 _RETURN:
  buf[i]=0;
  return i;
}

void I2CWrite(int dadr, int radr, unsigned char val){
  Wire.beginTransmission(dadr);
  Wire.write(radr);
  Wire.write(val);
  Wire.endTransmission();
}

void I2CPrint(int dadr, int radr, char *msg){
  int v;
  Serial.print(msg);
  v=I2CRead(dadr,radr);
  Serial.println(v,HEX);
}

void setup() {
  pinMode(PinLD, OUTPUT);
  pinMode(PinLD2,OUTPUT);
  pinMode(PinBZ, OUTPUT);
  pinMode(PinMTR,OUTPUT);
  pinMode(PinBRK,OUTPUT);
  pinMode(PinBTN,INPUT);
  pinMode(PinSL, INPUT);
  pinMode(PinSL2,INPUT);

  digitalWrite(PinBRK, 0);
  digitalWrite(PinMTR, 1);
  Serial.begin(115200);
  randomSeed(analogRead(PinPD));
  
  soundcode_pin   = 11;
  soundcode_tempo = 25;
  
  Wire.begin();
  /*
  I2CPrint(I2CAG,0x75,"75 Who am I  ");
  I2CPrint(I2CAG,0x6A,"6A User Ctrl ");
  I2CPrint(I2CAG,0x6B,"6B Pwr Mgmt1 ");
  I2CPrint(I2CAG,0x6C,"6C Pwr Mgmt2 ");
  I2CPrint(I2CAG,0x1A,"1A Config    ");
  I2CPrint(I2CAG,0x1B,"1B Gyro Cnf  ");
  I2CPrint(I2CAG,0x1C,"1C Accl Cnf  ");
  I2CPrint(I2CAG,0x1D,"1D Accl Cnf2 ");
  I2CPrint(I2CAG,0x37,"37 IntPinCfg ");
  I2CPrint(I2CM, 0x0a,"0A Mag Ctrl1 ");
  */
  I2CWrite(I2CAG,0x6B,0); // PwrMgmt1:wakeup
  I2CWrite(I2CAG,0x1B,0x18); // GyroCnf:2000dps,F=0
  I2CWrite(I2CAG,0x1C,0x18); // AcclCnf:16G
  I2CWrite(I2CAG,0x37,0x02); // IntPinCfg:Bypass for Magnetic Sensor
  I2CWrite(I2CM, 0x0a,0x16); // MagCtrl1:16bit,100Hz

  //soundcode_pin=13; // to mute sound

  init_ctrlpacket(&cpkt);
  init_senspacket(&spkt);

  soundcode_play(soundcode_f1gp);
  delay(1000);
  soundcode_play(soundcode_go);
  t0=t1=micros();
}

// communication mode: non-blocking, binary
void loop() {
  unsigned long t;

  // UART receive
  // NOTE: As for TX from PC, 1byte packet is much slower than 1word.
  while(Serial.available()>=4) { // read all availables for comm sync
    unsigned char rxd;
    rxd=Serial.read();
    if (rxd!=0x55) continue; // skip to sync word
    cpkt.packet[0]=rxd;           // sync word 0x55
    cpkt.packet[1]=Serial.read(); // [7:4]smpling,[3:1]option,[0]brake
    cpkt.packet[2]=Serial.read(); // accel[8] max:00<>ff:min
    cpkt.packet[3]=Serial.read(); // option[8]
    unpack_ctrlpacket(&cpkt);
    brk=cpkt.brk;
    digitalWrite(PinBRK,brk);
    mtr=cpkt.mtr;
    analogWrite(PinMTR,mtr);
    period=ratecode2period(cpkt.rate);
    if (cpkt.opt1) {
      status=0;
      digitalWrite(PinLD2,0);
    }
    if (cpkt.opt2) {
      soundcode_play(soundcode_eva);
    }
    if (cpkt.opt3) {
      setup();
      return;
    }
    run=1;
    t1=micros();
  }

  t=micros();
  if (t-t1>2000000) { // stop if no commands
    digitalWrite(PinMTR,1);mtr=0xff;
    digitalWrite(PinBRK,0);brk=0;
    if (run>0) soundcode_play(soundcode_failed);
    period=1000000;
    run=0;
  }
  
  if (t-t0<period) return;

  if (spkt_ready==0) { // tx data not ready
    spkt.stat=status;
    spkt.sw=
      (digitalRead(PinBTN)?0x01:0)|
      (digitalRead(PinSL)?0x02:0)|
      (digitalRead(PinSL2)?0x04:0);
    spkt.vol=(analogRead(PinVOL)>>2)&0xff;
    spkt.t=t;    // time stamp
    spkt.brk=brk;
    spkt.mtr=mtr;
    spkt.pd=analogRead(PinPD);
    
    // I2C Status, Magnetic(XYZ), Status
    if (I2CReadN(I2CM,0x02,i2cbuf,8)!=8) {
      status|=0x10;
      digitalWrite(PinLD2,HIGH);
      soundcode_playword(SNDERR07);
    }
    if ((i2cbuf[0]&0x01)==0x00) {//data not ready
      status|=0x40;
      digitalWrite(PinLD2,HIGH);
    }
    if ((i2cbuf[7]&0x08)==0x08) {//over flow
      status|=0x80;
      digitalWrite(PinLD2,HIGH);
    }
    spkt.mag[0]=byteHL2int(i2cbuf[2],i2cbuf[1]);
    spkt.mag[1]=byteHL2int(i2cbuf[4],i2cbuf[3]);
    spkt.mag[2]=byteHL2int(i2cbuf[6],i2cbuf[5]);
  
    // Acceleration(XYZ), Temperature, AngularVelocity(XYZ)
    if (I2CReadN(I2CAG,0x3B,i2cbuf,14)!=14) {
      status|=0x10;
      digitalWrite(PinLD2,HIGH);
      soundcode_playword(SNDERR08);
    }
    spkt.acl[0]=byteHL2int(i2cbuf[ 0],i2cbuf[ 1]);
    spkt.acl[1]=byteHL2int(i2cbuf[ 2],i2cbuf[ 3]);
    spkt.acl[2]=byteHL2int(i2cbuf[ 4],i2cbuf[ 5]);
    spkt.thm   =byteHL2int(i2cbuf[ 6],i2cbuf[ 7]);
    spkt.gyr[0]=byteHL2int(i2cbuf[ 8],i2cbuf[ 9]);
    spkt.gyr[1]=byteHL2int(i2cbuf[10],i2cbuf[11]);
    spkt.gyr[2]=byteHL2int(i2cbuf[12],i2cbuf[13]);

    pack_senspacket(&spkt);
    spkt_ready=1;
  }

  if (Serial.availableForWrite()>=SENSPKTSZ) {
    if (Serial.write(spkt.packet,SENSPKTSZ)<SENSPKTSZ) {
      status|=0x04;
      digitalWrite(PinLD2,HIGH);
      soundcode_playword(SNDERR01);
    }
    spkt_ready=0;
    t0=t0+period;
    if (t-t0>period) {
      status|=0x01;
      digitalWrite(PinLD2,HIGH);
      t0=t;
    }
  } else {
    status|=0x02;
    digitalWrite(PinLD2,HIGH);
  }

  led=led?0:1;
  digitalWrite(PinLD,led);
}
