/*
  Copyright (C) 2019 Tomonori IZUMI <izumi@ieee.org> All Rights Reserved.
*/

#ifndef _MINI4WD2PACKET_H_
#define _MINI4WD2PACKET_H_

#define CTRLPKTSZ 4
struct ctrlpacket_struct {
  unsigned char packet[CTRLPKTSZ];
  unsigned char brk;
  unsigned char mtr;
  unsigned char rate;
  unsigned char opt1;
  unsigned char opt2;
  unsigned char opt3;
  unsigned char opt4;
};

#define SENSPKTSZ 32
struct senspacket_struct {
  unsigned char packet[SENSPKTSZ];
  unsigned char stat;
  unsigned char sw;
  unsigned char vol;
  unsigned long t;
  unsigned char brk;
  unsigned char mtr;
  int pd;
  int mag[3];
  int acl[3];
  int gyr[3];
  int thm;
};

int byteHL2int(unsigned char h, unsigned char l);
unsigned long ratecode2period(int c);
int   init_ctrlpacket(struct ctrlpacket_struct *p);
int   pack_ctrlpacket(struct ctrlpacket_struct *p);
int unpack_ctrlpacket(struct ctrlpacket_struct *p);
int   init_senspacket(struct senspacket_struct *p);
int   pack_senspacket(struct senspacket_struct *p);
int unpack_senspacket(struct senspacket_struct *p);

#endif
