/*
  Copyright (C) 2019 Tomonori IZUMI <izumi@ieee.org> All Rights Reserved.
*/

#include "mini4WD2packet.h"

int byteHL2int(unsigned char h, unsigned char l){
  int v=0;
  v=(h&0x80)?-1:0;
  v=(v<<8)|h;
  v=(v<<8)|l;
  return v;
}

unsigned long ratecode2period(int c){
  switch (c) {
  case 0x01: return  200000; //    5Hz
  case 0x02: return  125000; //    8Hz
  case 0x03: return  100000; //   10Hz
  case 0x04: return   66666; //   15Hz
  case 0x05: return   50000; //   20Hz
  case 0x06: return   33333; //   30Hz
  case 0x07: return   20000; //   50Hz
  case 0x08: return   12500; //   80Hz
  case 0x09: return   10000; //  100Hz
  case 0x0a: return    6666; //  150Hz
  case 0x0b: return    5000; //  200Hz
  case 0x0c: return    3333; //  300Hz
  case 0x0d: return    2000; //  500Hz
  case 0x0e: return    1250; //  800Hz
  case 0x0f: return    1000; // 1000Hz
  default:   return 1000000; //    1Hz
  }
}

int init_ctrlpacket(struct ctrlpacket_struct *p){
  p->packet[0]=0x55; /* sync header */
  for (int i=1;i<CTRLPKTSZ;i++) p->packet[i]=0;
  p->rate=0;
  p->opt3=0;
  p->opt2=0;
  p->opt1=0;
  p->brk=0;
  p->mtr=0xff;
  p->opt4=0;
  return 1;
}

int pack_ctrlpacket(struct ctrlpacket_struct *p){
  p->packet[0]=0x55; /* sync header */
  p->packet[1]=
    ((p->rate&0xf)<<4)| //[7:4] smpl
    ((p->opt3)?0x8:0)|  //[3]   opt3
    ((p->opt2)?0x4:0)|  //[2]   opt2
    ((p->opt1)?0x2:0)|  //[1]   opt1
    ((p->brk )?0x1:0);  //[0]   brk
  p->packet[2]=p->mtr;
  p->packet[3]=p->opt4;
  return 1;
}

int unpack_ctrlpacket(struct ctrlpacket_struct *p){
  if (p->packet[0]!=0x55) return 0;
  p->rate=(p->packet[1]>>4)&0xf;
  p->opt3=(p->packet[1]&0x8)?1:0;
  p->opt2=(p->packet[1]&0x4)?1:0;
  p->opt1=(p->packet[1]&0x2)?1:0;
  p->brk =(p->packet[1]&0x1)?1:0;
  p->mtr =p->packet[2];
  p->opt4=p->packet[3];
  return 1;
}

int init_senspacket(struct senspacket_struct *p){
  p->packet[0]=0x55; /* sync header */
  for (int i=1;i<SENSPKTSZ;i++) p->packet[i]=0;
  p->stat  = 0;
  p->sw    = 0;
  p->vol   = 0;
  p->t     = 0;
  p->brk   = 0;
  p->mtr   = 0xff;
  p->pd    = 0;
  p->mag[0]= 0;
  p->mag[1]= 0;
  p->mag[2]= 0;
  p->acl[0]= 0;
  p->acl[1]= 0;
  p->acl[2]= 0;
  p->gyr[0]= 0;
  p->gyr[1]= 0;
  p->gyr[2]= 0;
  p->thm   = 0;
  return 0;
}

int pack_senspacket(struct senspacket_struct *p){
  int n=0;
  p->packet[n++]= 0x55;                // sync header
  p->packet[n++]= p->stat;             // status
  p->packet[n++]= p->sw;               // switches
  p->packet[n++]= p->vol;              // volume
  p->packet[n++]=(p->t     >>24)&0xff; // time
  p->packet[n++]=(p->t     >>16)&0xff;
  p->packet[n++]=(p->t     >> 8)&0xff;
  p->packet[n++]=(p->t     >> 0)&0xff;
  p->packet[n++]= p->brk;              // brake
  p->packet[n++]= p->mtr;              // motor
  p->packet[n++]=(p->pd    >> 8)&0xff; // photo diode
  p->packet[n++]=(p->pd    >> 0)&0xff;
  p->packet[n++]=(p->mag[0]>> 8)&0xff; // magnetic
  p->packet[n++]=(p->mag[0]>> 0)&0xff;
  p->packet[n++]=(p->mag[1]>> 8)&0xff;
  p->packet[n++]=(p->mag[1]>> 0)&0xff;
  p->packet[n++]=(p->mag[2]>> 8)&0xff;
  p->packet[n++]=(p->mag[2]>> 0)&0xff;
  p->packet[n++]=(p->acl[0]>> 8)&0xff; // accel
  p->packet[n++]=(p->acl[0]>> 0)&0xff;
  p->packet[n++]=(p->acl[1]>> 8)&0xff;
  p->packet[n++]=(p->acl[1]>> 0)&0xff;
  p->packet[n++]=(p->acl[2]>> 8)&0xff;
  p->packet[n++]=(p->acl[2]>> 0)&0xff;
  p->packet[n++]=(p->gyr[0]>> 8)&0xff; // gyro (angular velocity)
  p->packet[n++]=(p->gyr[0]>> 0)&0xff;
  p->packet[n++]=(p->gyr[1]>> 8)&0xff;
  p->packet[n++]=(p->gyr[1]>> 0)&0xff;
  p->packet[n++]=(p->gyr[2]>> 8)&0xff;
  p->packet[n++]=(p->gyr[2]>> 0)&0xff;
  p->packet[n++]=(p->thm   >> 8)&0xff; // thermo
  p->packet[n++]=(p->thm   >> 0)&0xff;
  return 1;
}

int unpack_senspacket(struct senspacket_struct *p){
  int n=0;
  if (p->packet[n++]!=0x55) return 0;
  p->stat = p->packet[n++];           // status
  p->sw   = p->packet[n++];           // switches
  p->vol  = p->packet[n++];           // volume
  p->t    = p->packet[n++];           // time
  p->t    =(p->t <<8)|p->packet[n++];
  p->t    =(p->t <<8)|p->packet[n++];
  p->t    =(p->t <<8)|p->packet[n++];
  p->brk  = p->packet[n++];           // brake
  p->mtr  = p->packet[n++];           // motor
  p->pd    =byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // photo diode
  p->mag[0]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // magnet
  p->mag[1]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // 
  p->mag[2]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // 
  p->acl[0]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // accel
  p->acl[1]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // 
  p->acl[2]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // 
  p->gyr[0]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // gyro
  p->gyr[1]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2;
  p->gyr[2]=byteHL2int(p->packet[n],p->packet[n+1]);n+=2;
  p->thm   =byteHL2int(p->packet[n],p->packet[n+1]);n+=2; // thermo

  return 1;
}
