/*
  Copyright (C) 2019 Tomonori IZUMI <izumi@ieee.org> All Rights Reserved.
*/

#ifndef _SOUNDCODE_H_
#define _SOUNDCODE_H_

#include <avr/io.h>
#include <avr/pgmspace.h>

int soundcode_pin    = 13; /* pin for buzzer */
int soundcode_tempo  = 25; /* to adjust tempo */
int soundcode_octave =  0; /* to adjust octave */

/* maximum and minimum frequency [Hz] */
#define SOUNDCODE_FMAX 5000
#define SOUNDCODE_FMIN   50

/* frequency [Hz] of each code at the highest octave level */
const uint16_t soundcode_freq[] PROGMEM =
  {/* 0 A  */ 14080,
   /* 1 A# */ 14917,
   /* 2 B  */ 15804,
   /* 3 C  */ 16744,
   /* 4 C# */ 17739,
   /* 5 D  */ 18794,
   /* 6 D# */ 19912,
   /* 7 E  */ 21096,
   /* 8 F  */ 22350,
   /* 9 F# */ 23679,
   /* a G  */ 25087,
   /* b G# */ 26879,
   /* c -- */     0,
   /* d -- */     0,
   /* e -- */     0,
   /* f -- */     0};

/* SoundCodes   C  D  E  F  G  A  B */
/*              3  5  7  8  a  0  2 */
/* OctaveCodes     0  1   2   3   4   5    6    7    8     9 */
/* A          silent 55 110 220 440 880 1760 3520 7040 14080 */

/* code for a single sound = [8bit:length,4bit:code,4bit:octave] */
/* playdata is an array of sound coudes, null-terminated */

const uint16_t soundcode_test[] PROGMEM =
  {
   /* F+*/ 0x1049, /* D */ 0x1045, /* A */ 0x1040, /* D */ 0x1045,
   /* E */ 0x1047, /* A */ 0x2050,                 /* A */ 0x1040,
   /* E */ 0x1047, /* F+*/ 0x1049, /* E */ 0x1047, /* A */ 0x1040,
   /* D */ 0x4045, 
   0x0000, 0x0000, 0x0000};

const uint16_t soundcode_chime[] PROGMEM =
  {
   /* E */ 0x2047, /* C */ 0x2043, /* D */ 0x2045, /* G */ 0x403a, 0x20ff,
   /* G */ 0x203a, /* D */ 0x2045, /* E */ 0x2047, /* C */ 0x4043, 0x20ff,
   0x0000, 0x0000, 0x0000};

const uint16_t soundcode_chime2[] PROGMEM =
  {
   /* C */ 0x2043, /* E */ 0x2047, /* D */ 0x2045, /* G */ 0x403a, 0x20ff,
   /* G */ 0x203a, /* D */ 0x2045, /* E */ 0x2047, /* C */ 0x4043, 0x20ff,
   0x0000, 0x0000, 0x0000};

const uint16_t soundcode_f1gp[] PROGMEM =
  {
                   /* D */ 0x0835, /* F */ 0x0838, /* A */ 0x0840,
   /* F */ 0x0848, /* A */ 0x0840, /* E */ 0x0847, /* C */ 0x0843,
   /* D */ 0x0845, /* A */ 0x0840, /* C */ 0x0843, /* G */ 0x083a,
   /* B-*/ 0x0841, /* F */ 0x0838, /* A */ 0x0840, /* F */ 0x1038, 
                   /* D */ 0x0835, /* F */ 0x0838, /* A */ 0x0840,
   /* F */ 0x0848, /* A */ 0x0840, /* E */ 0x0847, /* C */ 0x0843,
   /* D */ 0x0845, /* A */ 0x0840, /* C */ 0x0843, /* G */ 0x083a,
   /* B-*/ 0x0841, /* F */ 0x0838, /* B-*/ 0x0841, /* C */ 0x3843,
		                   /* B-*/ 0x0841, /* C */ 0x1843,
                                   /* B-*/ 0x0841, /* C */ 0x1743,
                   /* - */ 0x01ff, /* C */ 0x0843, /* D */ 0x1045,
   0x0000, 0x0000, 0x0000};

const uint16_t soundcode_go[] PROGMEM =
  {0x0840, 0x18ff, 0x0840, 0x18ff, 0x0840, 0x18ff, 0x1850, 0x08ff,
   0x0000, 0x0000, 0x0000};

const uint16_t soundcode_eva[] PROGMEM =
  {/* A */ 0x0f40, 0x01ff, /* C */ 0x0f43, 0x01ff,
   /* D */ 0x0b45, 0x01ff, /* C */ 0x0b43, 0x01ff,
   /* D */ 0x0745, 0x01ff, /* D */ 0x0745, 0x01ff,
   /* D */ 0x0745, 0x01ff, /* G */ 0x074a, 0x01ff,
   /* F */ 0x0748, 0x01ff, /* E */ 0x0347, 0x01ff,
   /* D */ 0x0745, 0x01ff, /* E */ 0x0347, 0x11ff,
   /* E */ 0x0f47, 0x01ff, /* G */ 0x0f4a, 0x01ff,
   /* A */ 0x0b50, 0x01ff, /* D */ 0x0b45, 0x01ff,
   /* C */ 0x0743, 0x01ff, /* G */ 0x074a, 0x01ff,
   /* G */ 0x074a, 0x01ff, /* E */ 0x0747, 0x01ff,
   /* G */ 0x074a, 0x01ff, /* G */ 0x0b4a, 0x01ff,
   /* A */ 0x1350, 0x01ff, 0x0000,0x0000,0x0000};

const uint16_t soundcode_failed[] PROGMEM =
  {0x0253,0x0255,0x024a,0x1aff,
   /* G */ 0x043a, 0x04ff, /* F */ 0x0448, 0x0cff, /* F */ 0x0448, 0x04ff, 
   /* F */ 0x0448, 0x04ff, /* E */ 0x0447, 0x0cff, /* D */ 0x0445, 0x04ff, 
   /* C */ 0x0443, 0x04ff, /* G */ 0x043a, 0x0cff, /* E */ 0x0437, 0x04ff,
   /* C */ 0x0433, 0x1cff, 0x0000,0x0000,0x0000};


/* play a music given an array of sound codes */
void soundcode_play(const uint16_t code[]);

/* play a music given a word packed codes */
/* scan each 4bits from MSB to LSB */
/* first non-zero 4bit is the octave */
/* second 4bit is the sound code */
/* each 4bit following is the moving step of the code */
void soundcode_playword(uint32_t code);

#endif
