#include <stdio.h>
#include <stdlib.h>

#include "mini4WD2packet.h"
struct senspacket_struct spkt;

int main(int argc, char **argv){
  if (argc<2) {
    fprintf(stderr,"usage: %s [record data file]\n",argv[0]);
    exit(1);
  }

  FILE *recfp=fopen(argv[1],"rb");
  if (recfp==NULL){
    fprintf(stderr,"can't open record data file (%s)\n",argv[1]);
    exit(1);
  }

  while (1) {
    int n=fread(spkt.packet,1,SENSPKTSZ,recfp);
    if (n<0) {
      fprintf(stderr,"can't read record data file (%s)\n",argv[1]);
      exit(1);
    }
    if (n<SENSPKTSZ) break;
    unpack_senspacket(&spkt);
    printf("%6ldms ",spkt.t/1000);
    printf("STA%02x BTN%02x VOL%02x ",spkt.stat,spkt.sw,spkt.vol);
    printf("BRK%d MTR%02x ",spkt.brk,spkt.mtr);
    printf("PD%4d ",spkt.pd);
    printf("MAG%5d%5d%5d ",spkt.mag[0],spkt.mag[1],spkt.mag[2]);
    printf("ACL%5d%5d%5d ",spkt.acl[0],spkt.acl[1],spkt.acl[2]);
    printf("GYR%5d%5d%5d ",spkt.gyr[0],spkt.gyr[1],spkt.gyr[2]);
    printf("THM%3d ",spkt.thm);
    printf("\n");
  }

  fclose(recfp);
  
  return 0;
}
