#include "mini4WD2.h"
#include "soundcode.h"

unsigned long t1=0,t0=0;
int count=-1;

void usage() {
  Serial.println("mini4WD2 laptimer");
  Serial.println("A0  sen: sensor in");
  Serial.println("A2  vol: threshould");
  Serial.println("D7  ssw: greater/smaller");
  Serial.println("D6  ssw: measure/status");
  Serial.println("D10 btn: reset lap & usage");
  Serial.println("D13 led: sen<vol");
  Serial.println("D12 led: sen>vol");
}

void setup() {
  pinMode(PinLD, OUTPUT);
  pinMode(PinLD2,OUTPUT);
  pinMode(PinBZ, OUTPUT);
  pinMode(PinMTR,OUTPUT);
  pinMode(PinBRK,OUTPUT);
  pinMode(PinMTR,OUTPUT);
  pinMode(PinBTN,INPUT);
  pinMode(PinSL, INPUT);
  pinMode(PinSL2,INPUT);

  digitalWrite(PinBRK, 0);
  digitalWrite(PinMTR, 1);
  Serial.begin(115200);
  randomSeed(analogRead(A0));

  usage();
  
  soundcode_pin   = 11;
  soundcode_tempo = 25;
  soundcode_play(soundcode_go);
  
  t0=t1=millis();
  count=-1;
}

void loop() {
  unsigned long t,l1,l0;
  int btn,sl1,sl2,vol,sen;
  int i;
  
  t=millis();
  btn=digitalRead(PinBTN);
  sl1=digitalRead(PinSL);
  sl2=digitalRead(PinSL2);
  vol=analogRead(PinVOL);
  sen=analogRead(A0);

  if (sen<vol) {
    digitalWrite(PinLD,1);
    digitalWrite(PinLD2,0);
  } else {
    digitalWrite(PinLD,0);
    digitalWrite(PinLD2,1);
  }
  
  if (sl2==0) {
    // measure
    if (((sl1==0)&&(sen>vol))||((sl1!=0)&&(sen<vol))){
      if (count<0) {
	t0=t1=t;
	count=0;
      }
      l1=t-t1;
      l0=t-t0;
      Serial.print(count);
      Serial.print("\t");
      Serial.print(l0);
      Serial.print("\t");
      Serial.println(l1);
      // place delay to ignore the same object
      soundcode_playword(0x4034);
      delay(500);
      t1=t;
      count++;
    }
  } else {
    // status
    Serial.print("D10=");
    Serial.print(btn);
    Serial.print("\tD7=");
    Serial.print(sl1);
    Serial.print("\tD6=");
    Serial.print(sl2);
    Serial.print("\tA2=");
    Serial.print(vol);
    Serial.print("\tA0=");
    Serial.println(sen);
    count=-1;
    delay(500);
  }

  if (btn==0) {
    usage();
    soundcode_playword(0x403);
    count=-1;
    delay(500);
  }

}
