/*
 (C) Tomonori Izumi <izumi@ieee.org>, Oct. 2016. All rigts reserved.
*/

`default_nettype none
  
module PWM_module(period,width,pwm,clk,rstn);
   parameter BW=32;
   input  /* */ wire [BW-1:0] period, width;
   output /* */ wire pwm;
   input  /* */ wire clk,rstn;

   reg [BW-1:0] period_r, width_r, count=0;
   reg 		pwm_r=0;
   assign 	pwm=pwm_r;

   always @(posedge clk) begin
      period_r<=period;
      width_r<=width;
   end

   always @(posedge clk)
     if (count<period_r)
       count<=count+1;
     else
       count<=0;
   
   always @(posedge clk)
     if (count<width_r)
       pwm_r<=1;
     else
       pwm_r<=0;

endmodule

module MOTOR_COUNT_module(sa,sb,count,clk,rstn);
   parameter BW=32;
   input  /* */ wire sa,sb;
   output /* */ wire [BW-1:0] count;
   input  /* */ wire clk,rstn;

   reg [BW-1:0] count_r=0;
   reg 		sa1=0,sb1=0,sa2=0,sb2=0;
   assign 	count=count_r;

   always @(posedge clk) begin
      sa2<=sa1;
      sb2<=sb1;
      sa1<=sa;
      sb1<=sb;
   end

   always @(posedge clk)
     if (rstn==0)
       count_r<=0;
     else
       case ({sa2,sb2,sa1,sb1})
	 4'b0010: count_r<=count_r+1;
	 4'b1011: count_r<=count_r+1;
	 4'b1101: count_r<=count_r+1;
	 4'b0100: count_r<=count_r+1;
	 4'b0001: count_r<=count_r-1;
	 4'b0111: count_r<=count_r-1;
	 4'b1110: count_r<=count_r-1;
	 4'b1000: count_r<=count_r-1;
       endcase
endmodule

`default_nettype wire
