/*
 (C) Tomonori Izumi <izumi@ieee.org>, Sep. 2016. All rigts reserved.
 for xc7z020clg484-1 on Digilent ZYBO
 					Ver.2016.09.13a
*/

/*
 
 memo: ZYBOT-R connection
 
 Camera Up-Down    ... CON3 PWM P3 = jd9
 Camera Left-Right ... CON3 PWM P4 = jd10
 Wheel Right       ... HB5 (DIR,EN,SA,SB) = (je1,je2,je3,je4)
 Wheel Left        ... HB5 (DIR,EN,SA,SB) = (je7,je8,je9,je10)
 Character Display ... UART TX = jb10
 
 */
 
//`timescale 1ns / 1ps

`default_nettype none

module ZYBO_top
  (CLK125M,btn,sw,led,
   ja1,ja2,ja3,ja4,ja7,ja8,ja9,ja10,
   jb1,jb2,jb3,jb4,jb7,jb8,jb9,jb10,
   jc1,jc2,jc3,jc4,jc7,jc8,jc9,jc10,
   jd1,jd2,jd3,jd4,jd7,jd8,jd9,jd10,
   je1,je2,je3,je4,je7,je8,je9,je10,
   DDR_addr, DDR_ba, DDR_cas_n, DDR_ck_n, DDR_ck_p, DDR_cke, DDR_cs_n, DDR_dm,
   DDR_dq, DDR_dqs_n, DDR_dqs_p, DDR_odt, DDR_ras_n, DDR_reset_n, DDR_we_n,
   FIXED_IO_ddr_vrn, FIXED_IO_ddr_vrp, FIXED_IO_mio, FIXED_IO_ps_clk,
   FIXED_IO_ps_porb, FIXED_IO_ps_srstb);
   
   input  /* */ wire        CLK125M;
   input  /* */ wire [ 3:0] btn;
   input  /* */ wire [ 3:0] sw;
   output /* */ wire [ 3:0] led;
   inout  /* */ wire        ja1,ja2,ja3,ja4,ja7,ja8,ja9,ja10; // Pmod JA
   inout  /* */ wire        jb1,jb2,jb3,jb4,jb7,jb8,jb9,jb10; // Pmod JB
   inout  /* */ wire        jc1,jc2,jc3,jc4,jc7,jc8,jc9,jc10; // Pmod JC
   inout  /* */ wire        jd1,jd2,jd3,jd4,jd7,jd8,jd9,jd10; // Pmod JD
   inout  /* */ wire        je1,je2,je3,je4,je7,je8,je9,je10; // Pmod JE
   inout  /* */ wire [14:0] DDR_addr;
   inout  /* */ wire [ 2:0] DDR_ba;
   inout  /* */ wire        DDR_cas_n;
   inout  /* */ wire        DDR_ck_n;
   inout  /* */ wire        DDR_ck_p;
   inout  /* */ wire        DDR_cke;
   inout  /* */ wire        DDR_cs_n;
   inout  /* */ wire [ 3:0] DDR_dm;
   inout  /* */ wire [31:0] DDR_dq;
   inout  /* */ wire [ 3:0] DDR_dqs_n;
   inout  /* */ wire [ 3:0] DDR_dqs_p;
   inout  /* */ wire        DDR_odt;
   inout  /* */ wire        DDR_ras_n;
   inout  /* */ wire        DDR_reset_n;
   inout  /* */ wire        DDR_we_n;
   inout  /* */ wire        FIXED_IO_ddr_vrn;
   inout  /* */ wire        FIXED_IO_ddr_vrp;
   inout  /* */ wire [53:0] FIXED_IO_mio;
   inout  /* */ wire        FIXED_IO_ps_clk;
   inout  /* */ wire        FIXED_IO_ps_porb;
   inout  /* */ wire        FIXED_IO_ps_srstb;
   
   wire   CLK125M_ibuf,clk0;
   IBUFG ibuf_clk(.I(CLK125M), .O(CLK125M_ibuf));
   BUFG  buf_clk(.I(CLK125M_ibuf),.O(clk0));

   wire clk;
   wire rstn;

   //assign 	clk=arm_clko;
   //assign 	rstn=arm_rstno;
   assign 	clk=clk0;
   assign 	rstn=1'b1;
   
   //----------------------------------------------------------------
   // setup : ėpJE^Ɠ̓`^O΍Ao
   // cNbN PLnclk0PSnclk̂Qn
   
   reg [31:0] 	counter0=0;
   always @(posedge clk0)
     counter0<=counter0+1;
   
   reg [31:0] 	counter=0;
   always @(posedge clk)
     if (!rstn) counter<=0;
     else counter<=counter+1;
   
   reg [3:0] 	led_r;
   reg [3:0] 	sw_r;
   reg [3:0] 	btn_r;

   always @(posedge clk)
     if (counter[15:0]==0) begin // anti-chattering
	sw_r  <= sw;
	btn_r <= btn;
     end
   
   assign led=led_r;

   //----------------------------------------------------------------
   // PWM motor control

   // servo: period 20.0ms, width 0.9-2.1ms
   //  20.0ms=2500000clk@125MHz
   //   0.9ms= 112500clk@125MHz
   //   1.5ms= 187500clk@125MHz
   //   2.1ms= 262500clk@125MHz
   wire [31:0] servo_v_width, servo_h_width;
   wire        servo_v_pwm,   servo_h_pwm;
   assign      servo_v_width
     = (btn_r[0]==0) ? 32'd187500 : (sw_r[0]==0) ? 32'd112500 : 32'd262500;
   assign      servo_h_width
     = (btn_r[1]==0) ? 32'd187500 : (sw_r[1]==0) ? 32'd112500 : 32'd262500;
   defparam    servo_v_pwm_i.BW=32;
   defparam    servo_h_pwm_i.BW=32;
   PWM_module  servo_v_pwm_i(32'd2500000,servo_v_width,servo_v_pwm,clk,rstn);
   PWM_module  servo_h_pwm_i(32'd2500000,servo_h_width,servo_h_pwm,clk,rstn);

   
   // motor: period 40us, width 0-40us
   // 40us=5000clk@125MHz
   wire        motor_r_sa, motor_r_sb, motor_l_sa, motor_l_sb;
   wire [31:0] motor_r_c,  motor_l_c;
   defparam    motor_r_count_i.BW=32;
   defparam    motor_l_count_i.BW=32;
   MOTOR_COUNT_module motor_r_count_i(motor_r_sa, motor_r_sb,motor_r_c,clk,rstn);
   MOTOR_COUNT_module motor_l_count_i(motor_l_sa,~motor_l_sb,motor_l_c,clk,rstn);
   wire [31:0] motor_r_width, motor_l_width;
   wire        motor_r_pwm,   motor_l_pwm;
   wire        motor_r_dir,   motor_l_dir;
   assign      motor_r_width
     = (btn_r[2]==0) ? 32'd0 : (sw_r[2]==0) ? 32'd3000 : 32'd5000;
   assign      motor_l_width
     = (btn_r[3]==0) ? 32'd0 : (sw_r[3]==0) ? 32'd3000 : 32'd5000;
   assign      motor_r_dir=sw_r[0];
   assign      motor_l_dir=sw_r[1];
   defparam    motor_r_pwm_i.BW=32;
   defparam    motor_l_pwm_i.BW=32;
   PWM_module  motor_r_pwm_i(32'd5000,motor_r_width,motor_r_pwm,clk,rstn);
   PWM_module  motor_l_pwm_i(32'd5000,motor_l_width,motor_l_pwm,clk,rstn);

   
   //----------------------------------------------------------------
   // setup : LED \ݒ
   
   always @(posedge clk)
     case (btn_r)
       4'b0001: led_r<=sw_r;
       4'b0010: led_r<=counter[23:20];
       4'b0100: led_r<=counter[27:24];
       4'b1000: led_r<=counter[31:28];
       default: led_r<=sw_r;
     endcase

   //----------------------------------------------------------------
   // setup : ėpo̓s̐ڑ

   assign      ja1 =1'bz;
   assign      ja2 =1'bz;
   assign      ja3 =1'bz;
   assign      ja4 =1'bz;
   assign      ja7 =1'bz;
   assign      ja8 =1'bz;
   assign      ja9 =1'bz;
   assign      ja10=1'bz;

   assign      jb1 =1'bz;
   assign      jb2 =1'bz;
   assign      jb3 =1'bz;
   assign      jb4 =1'bz;
   assign      jb7 =1'bz;
   assign      jb8 =1'bz;
   assign      jb9 =1'bz;
   assign      jb10=1'bz;

   assign      jc1 =1'bz;
   assign      jc2 =1'bz;
   assign      jc3 =1'bz;
   assign      jc4 =1'bz;
   assign      jc7 =1'bz;
   assign      jc8 =1'bz;
   assign      jc9 =1'bz;
   assign      jc10=1'bz;

   assign      jd1 =1'bz;
   assign      jd2 =1'bz;
   assign      jd3 =1'bz;
   assign      jd4 =1'bz;
   assign      jd7 =1'bz;
   assign      jd8 =1'bz;
   //assign      jd9 =1'b0;
   assign      jd9 =servo_v_pwm;
   //assign      jd10=1'b0;
   assign      jd10=servo_h_pwm;

   //assign      je1 =1'b1;
   //assign      je2 =1'b0;
   //assign      je3 =1'bz;
   //assign      je4 =1'bz;
   assign      je1 =motor_r_dir;
   assign      je2 =motor_r_pwm;
   assign      motor_r_sa=je3;
   assign      motor_r_sb=je4;
   //assign      je7 =1'b0;
   //assign      je8 =1'b0;
   //assign      je9 =1'bz;
   //assign      je10=1'bz;
   assign      je7 =motor_l_dir;
   assign      je8 =motor_l_pwm;
   assign      motor_l_sa=je9;
   assign      motor_l_sb=je10;
   
endmodule

`default_nettype wire

// [Synth 8-3331] unconnected port
// [Synth 8-3848] does not have driver
// [Synth 8-3295] tying undriven pin to constant
