// (C) Tomonori Izumi <izumi@ieee.org>, Oct. 2025


`timescale 1ns / 1ns

module top;
   reg xreset;
   reg clock;
   reg run;
   wire [7:0] count;
   
   counter_module counter1(.xreset(xreset), .clock(clock), .run(run), .count(count));

   always #5 clock = ~clock;

   always @(posedge clock) begin
      $display("time=%5d xreset=%b run=%b count=%2x",$time, xreset, run, count);
   end
   
   initial begin
      $dumpfile("tb_counter.vcd");
      $dumpvars;
      clock  <= 1'b1;
      run    <= 1'b0;
      xreset <= 1'b0;
      #32;
      xreset <= 1'b1;
      #30;
      run    <= 1'b1;
      #50;
      run    <= 1'b0;
      #30;
      run    <= 1'b1;
      #70;
      $finish;
   end

endmodule
