/*
 (C) Tomonori Izumi <izumi@ieee.org>, Oct. 2025. All rigts reserved.
 					Ver.2025.11.02a
*/


`timescale 1ns / 1ps

`default_nettype none

module top;
   reg clk;
   reg btn0,btn1,btn2,btn3;
   reg sw0,sw1,sw2,sw3;
   wire	ld0,ld1,ld2,ld3;
   wire	xor_out;
   integer i;

   //----------------------------------------------------------------
   // IP Integrator (Block Design) Ƃ̐ڑ

   LogicGates LogicGates_i
     (.btn0(btn0),.btn1(btn1),.btn2(btn2),.btn3(btn3),
      .sw0(sw0),.sw1(sw1),.sw2(sw2),.sw3(sw3),
      .ld0(ld0),.ld1(ld1),.ld2(ld2),.ld3(ld3),
      .clk(clk));

   always #5 clk = ~clk;

   always @(posedge clk) begin
      $display("time=%5d btn=%b%b%b%b sw=%b%b%b%b ld=%b%b%b%b",
	       $time,
	       btn0,btn1,btn2,btn3,
	       sw0, sw1, sw2, sw3,
	       ld0, ld1, ld2, ld3);
   end


   //  Block Design ̃WX^𒼐ڑ삷
   initial #2 LogicGates_i.rizm_dff_0.inst.Q_reg<=1;

   //  Block Design ̃C𒼐ڊϑ
   assign xor_out = LogicGates_i.rizm_xor2_0_O;
   
   initial begin
      $dumpfile("LogicGates.vcd");
      $dumpvars;
      clk  <= 1'b1;

      #2; // NbNJڂƁghɂȂȂ悤ɁAď炷
      for (i=0;i<32;i=i+1) begin
	 btn0<=$random&1'b1;
	 btn1<=$random&1'b1;
	 btn2<=$random&1'b1;
	 btn3<=$random&1'b1;
	 sw0<=$random&1'b1;
	 sw1<=$random&1'b1;
	 sw2<=$random&1'b1;
	 sw3<=$random&1'b1;
	 #10;
      end
      #10;
      $finish;
   end

endmodule

`default_nettype wire

// [Synth 8-3331] unconnected port
// [Synth 8-3848] does not have driver
// [Synth 8-3295] tying undriven pin to constant
