/*
 (C) Tomonori Izumi <izumi@ieee.org>, Oct. 2025. All rigts reserved.
 for xc7z020clg484-1 on Digilent Zybo
 					Ver.2025.10.26a
*/


//`timescale 1ns / 1ps

`default_nettype none

module Zybo_top
  (
   btn,sw,led,
   // ja1,ja2,ja3,ja4,ja7,ja8,ja9,ja10,
   // jb1,jb2,jb3,jb4,jb7,jb8,jb9,jb10,
   // jc1,jc2,jc3,jc4,jc7,jc8,jc9,jc10,
   // jd1,jd2,jd3,jd4,jd7,jd8,jd9,jd10,
   // je1,je2,je3,je4,je7,je8,je9,je10,
   // DDR_addr, DDR_ba, DDR_cas_n, DDR_ck_n, DDR_ck_p, DDR_cke, DDR_cs_n, DDR_dm,
   // DDR_dq, DDR_dqs_n, DDR_dqs_p, DDR_odt, DDR_ras_n, DDR_reset_n, DDR_we_n,
   // FIXED_IO_ddr_vrn, FIXED_IO_ddr_vrp, FIXED_IO_mio, FIXED_IO_ps_clk,
   // FIXED_IO_ps_porb, FIXED_IO_ps_srstb,
   CLK125M);
   
   input  /* */ wire [ 3:0] btn;
   input  /* */ wire [ 3:0] sw;
   output /* */ wire [ 3:0] led;
   // inout  /* */ wire        ja1,ja2,ja3,ja4,ja7,ja8,ja9,ja10; // Pmod JA
   // inout  /* */ wire        jb1,jb2,jb3,jb4,jb7,jb8,jb9,jb10; // Pmod JB
   // inout  /* */ wire        jc1,jc2,jc3,jc4,jc7,jc8,jc9,jc10; // Pmod JC
   // inout  /* */ wire        jd1,jd2,jd3,jd4,jd7,jd8,jd9,jd10; // Pmod JD
   // inout  /* */ wire        je1,je2,je3,je4,je7,je8,je9,je10; // Pmod JE
   // inout  /* */ wire [14:0] DDR_addr;
   // inout  /* */ wire [ 2:0] DDR_ba;
   // inout  /* */ wire        DDR_cas_n;
   // inout  /* */ wire        DDR_ck_n;
   // inout  /* */ wire        DDR_ck_p;
   // inout  /* */ wire        DDR_cke;
   // inout  /* */ wire        DDR_cs_n;
   // inout  /* */ wire [ 3:0] DDR_dm;
   // inout  /* */ wire [31:0] DDR_dq;
   // inout  /* */ wire [ 3:0] DDR_dqs_n;
   // inout  /* */ wire [ 3:0] DDR_dqs_p;
   // inout  /* */ wire        DDR_odt;
   // inout  /* */ wire        DDR_ras_n;
   // inout  /* */ wire        DDR_reset_n;
   // inout  /* */ wire        DDR_we_n;
   // inout  /* */ wire        FIXED_IO_ddr_vrn;
   // inout  /* */ wire        FIXED_IO_ddr_vrp;
   // inout  /* */ wire [53:0] FIXED_IO_mio;
   // inout  /* */ wire        FIXED_IO_ps_clk;
   // inout  /* */ wire        FIXED_IO_ps_porb;
   // inout  /* */ wire        FIXED_IO_ps_srstb;
   input  /* */ wire        CLK125M;

   //----------------------------------------------------------------
   // wœڎ邽߂ɌxNbN̐
   // GbW̔ȃ^C~O邽߁AƂ negedge Ő
   
   wire	clk0;
   IBUFG ibuf_clk(.I(CLK125M), .O(clk0));

   reg [31:0] clkdiv=0;
   always @(negedge clk0)
     clkdiv<=clkdiv+1;

   // 125MHz/2^27=1b
   wire clk2;
   BUFG  buf_clk(.I(clkdiv[26]),.O(clk2));
   
   //----------------------------------------------------------------
   // setup : ̓`^O΍

   reg [31:0] 	counter=0;
   always @(posedge clk0)
     counter<=counter+1;

   reg [3:0] 	sw_r;
   reg [3:0] 	btn_r;
   reg [3:0] 	led_r;
   wire [3:0]	led_w;
   
   always @(posedge clk0)
     if (counter[15:0]==0) begin // anti-chattering
	sw_r  <= sw;
	btn_r <= btn;
     end

   always @(posedge clk0)
     led_r <= led_w;

   assign led = led_r;

   //----------------------------------------------------------------
   // IP Integrator (Block Design) Ƃ̐ڑ

   LogicGates LogicGates_i
     (.btn0(btn_r[0]),
      .btn1(btn_r[1]),
      .btn2(btn_r[2]),
      .btn3(btn_r[3]),
      .sw0(sw_r[0]),
      .sw1(sw_r[1]),
      .sw2(sw_r[2]),
      .sw3(sw_r[3]),
      .ld0(led_w[0]),
      .ld1(led_w[1]),
      .ld2(led_w[2]),
      .ld3(led_w[3]),
      .clk(clk2));
   
endmodule

`default_nettype wire

// [Synth 8-3331] unconnected port
// [Synth 8-3848] does not have driver
// [Synth 8-3295] tying undriven pin to constant
