set PROJECTNAME "logicgates"
set BASEDIR "C:/home/t-izumi/${PROJECTNAME}"

set DESIGNNAME "LogicGates"

# for ZYBO
#set BOARDID "digilentinc.com:zybo:part0:1.0"
#set PARTID "xc7z010clg400-1"
#set BOARDXDC "Zybo.xdc"

# for ZYBO Z7-10
#set BOARDID "digilentinc.com:zybo-z7-10:part0:1.2"
#set PARTID "xc7z010clg400-1"
#set BOARDXDC "Zybo-Z7.xdc"

# for ZYBO Z7-20
set BOARDID "digilentinc.com:zybo-z7-20:part0:1.2"
set PARTID "xc7z020clg400-1"
set BOARDXDC "Zybo-Z7.xdc"


################################################################

create_project ${PROJECTNAME} ${BASEDIR} -part ${PARTID}
set_property board_part ${BOARDID} [current_project]

################################################################

set_property  ip_repo_paths  ${BASEDIR}/ip_repo [current_project]
update_ip_catalog

################################################################

file mkdir ${BASEDIR}/${PROJECTNAME}.srcs/constrs_1
file mkdir ${BASEDIR}/${PROJECTNAME}.srcs/constrs_1/new
close [ open ${BASEDIR}/${PROJECTNAME}.srcs/constrs_1/new/debug.xdc w ]
add_files -fileset constrs_1 ${BASEDIR}/${PROJECTNAME}.srcs/constrs_1/new/debug.xdc
set_property target_constrs_file ${BASEDIR}/${PROJECTNAME}.srcs/constrs_1/new/debug.xdc [current_fileset -constrset]

add_files -fileset constrs_1 -norecurse ${BASEDIR}/${BOARDXDC}

add_files -norecurse ${BASEDIR}/Zybo_top.v

update_compile_order -fileset sources_1

set_property SOURCE_SET sources_1 [get_filesets sim_1]
add_files -fileset sim_1 -norecurse ${BASEDIR}/LogicGates_sim.v
set_property top top [get_filesets sim_1]
set_property top_lib xil_defaultlib [get_filesets sim_1]

update_compile_order -fileset sim_1

################################################################

create_bd_design ${DESIGNNAME}

create_bd_port -dir I -type clk -freq_hz 1000000 clk
create_bd_port -dir I btn0
create_bd_port -dir I btn1
create_bd_port -dir I btn2
create_bd_port -dir I btn3
create_bd_port -dir I sw0
create_bd_port -dir I sw1
create_bd_port -dir I sw2
create_bd_port -dir I sw3
create_bd_port -dir O ld0
create_bd_port -dir O ld1
create_bd_port -dir O ld2
create_bd_port -dir O ld3

create_bd_cell -type ip -vlnv www.ritsumei.ac.jp:user:rizm_and2:1.0 rizm_and2_0
connect_bd_net [get_bd_ports sw0] [get_bd_pins rizm_and2_0/A]
connect_bd_net [get_bd_ports sw1] [get_bd_pins rizm_and2_0/B]
connect_bd_net [get_bd_ports ld0] [get_bd_pins rizm_and2_0/O]

create_bd_cell -type ip -vlnv www.ritsumei.ac.jp:user:rizm_or2:1.0 rizm_or2_0
connect_bd_net [get_bd_ports sw0] [get_bd_pins rizm_or2_0/A]
connect_bd_net [get_bd_ports sw1] [get_bd_pins rizm_or2_0/B]
connect_bd_net [get_bd_ports ld1] [get_bd_pins rizm_or2_0/O]

create_bd_cell -type ip -vlnv www.ritsumei.ac.jp:user:rizm_not:1.0 rizm_not_0
connect_bd_net [get_bd_ports sw2] [get_bd_pins rizm_not_0/A]
connect_bd_net [get_bd_ports ld2] [get_bd_pins rizm_not_0/O]

create_bd_cell -type ip -vlnv www.ritsumei.ac.jp:user:rizm_xor2:1.0 rizm_xor2_0
create_bd_cell -type ip -vlnv www.ritsumei.ac.jp:user:rizm_dff:1.0 rizm_dff_0

connect_bd_net [get_bd_ports sw3] [get_bd_pins rizm_xor2_0/A]
connect_bd_net [get_bd_pins rizm_dff_0/Q] [get_bd_pins rizm_xor2_0/B]
connect_bd_net [get_bd_pins rizm_dff_0/D] [get_bd_pins rizm_xor2_0/O]
connect_bd_net [get_bd_ports ld3] [get_bd_pins rizm_dff_0/Q]
connect_bd_net [get_bd_ports clk] [get_bd_pins rizm_dff_0/CK]

regenerate_bd_layout
#regenerate_bd_layout -routing

update_compile_order -fileset sources_1
validate_bd_design

################################################################

generate_target all [get_files  ${BASEDIR}/${PROJECTNAME}.srcs/sources_1/bd/${DESIGNNAME}/${DESIGNNAME}.bd]

#catch { config_ip_cache -export [get_ips -all ${DESIGNNAME}_rizm_and2_0_0] }
#catch { config_ip_cache -export [get_ips -all ${DESIGNNAME}_rizm_or2_0_0] }
#catch { config_ip_cache -export [get_ips -all ${DESIGNNAME}_rizm_not_0_0] }
#catch { config_ip_cache -export [get_ips -all ${DESIGNNAME}_rizm_xor2_0_0] }
#catch { config_ip_cache -export [get_ips -all ${DESIGNNAME}_rizm_dff_0_0] }

export_ip_user_files -of_objects [get_files ${BASEDIR}/${PROJECTNAME}.srcs/sources_1/bd/${DESIGNNAME}/${DESIGNNAME}.bd] -no_script -sync -force -quiet

create_ip_run [get_files -of_objects [get_fileset sources_1] ${BASEDIR}/${PROJECTNAME}.srcs/sources_1/bd/${DESIGNNAME}/${DESIGNNAME}.bd]

launch_runs ${DESIGNNAME}_rizm_and2_0_0_synth_1 ${DESIGNNAME}_rizm_dff_0_0_synth_1 ${DESIGNNAME}_rizm_not_0_0_synth_1 ${DESIGNNAME}_rizm_or2_0_0_synth_1 ${DESIGNNAME}_rizm_xor2_0_0_synth_1 -jobs 4

export_simulation -lib_map_path [list {modelsim=${BASEDIR}/${PROJECTNAME}.cache/compile_simlib/modelsim} {questa=${BASEDIR}/${PROJECTNAME}.cache/compile_simlib/questa} {riviera=${BASEDIR}/${PROJECTNAME}.cache/compile_simlib/riviera} {activehdl=${BASEDIR}/${PROJECTNAME}.cache/compile_simlib/activehdl}] -of_objects [get_files ${BASEDIR}/${PROJECTNAME}.srcs/sources_1/bd/${PROJECTNAME}/${PROJECTNAME}.bd] -directory ${BASEDIR}/${PROJECTNAME}.ip_user_files/sim_scripts -ip_user_files_dir ${BASEDIR}/${PROJECTNAME}.ip_user_files -ipstatic_source_dir ${BASEDIR}/${PROJECTNAME}.ip_user_files/ipstatic -use_ip_compiled_libs -force -quiet

################################################################

launch_simulation
source top.tcl

################################################################

synth_design -top Zybo_top -part ${PARTID} -lint

launch_runs synth_1 -jobs 4

launch_runs impl_1 -jobs 4

launch_runs write_bitstream -jobs 4

################################################################

open_hw_manager
connect_hw_server -allow_non_jtag

open_hw_target

set_property PROGRAM.FILE {${BASEDIR}/${PROJECTNAME}.runs/impl_1/Zybo_top.bit} [get_hw_devices xc7z020_1]
current_hw_device [get_hw_devices xc7z020_1]
refresh_hw_device -update_hw_probes false [lindex [get_hw_devices xc7z020_1] 0]

set_property PROBES.FILE {} [get_hw_devices xc7z020_1]
set_property FULL_PROBES.FILE {} [get_hw_devices xc7z020_1]
set_property PROGRAM.FILE {${BASEDIR}/${PROJECTNAME}.runs/impl_1/Zybo_top.bit} [get_hw_devices xc7z020_1]
program_hw_devices [get_hw_devices xc7z020_1]

refresh_hw_device [lindex [get_hw_devices xc7z020_1] 0]

################################################################
