! 1Rxn`
!                          2021-10-18 ɒÖas@ّwHwssHw
!                                     izuno@se.ritsumei.ac.jp
! 𕜌̓fF`CoCjAC򉻃Nt^
! ϕFLQNb^@
! A. Wambecq: Rational Runge-Kutta methods for solving systems of ordinary differential equations,
!    Computing, Vol. 20, Issue 4, pp 333-342, 1978.

!
! ̓t@C
! input.txt   ep[^De̓Tvt@CQƁD1sɐĂD
! eq.txt      nkgDgal(=cm/s/s)Pʂ̉x݂̂ĂD
!
! o̓t@C
! results.txt ŗLlCő剞lȂ
! output.txt  i^u؂t@Cj

program response
implicit none
integer :: n, i, j, model, bun
double precision, allocatable :: eq(:), tim(:), dis(:), vel(:), acc(:), frc(:), eqm(:)
double precision :: dt, dtorg, m, c, h, z0, z1, dz, yy, k1, k2, PI
double precision :: xmax, xmin, ymax, ymin, x, v, a, f, fold, xold
double precision :: v2, x2, y11, y21, y12, y22, y13, y23, G11, G13, G33
double precision, parameter :: EPS = 0.0001    ! ̒lȏȂ犄Z
character(80) :: line
character(1), parameter :: tab = char(9)       ! ^uER[h
PI = 4.d0 * atan( 1.d0 )                       ! ~

! 
open(1, file='input.txt', status='old')
read(1, '(a)') line
read(1, *) n        ! nkg̃f[^
read(1, '(a)') line
read(1, *) dtorg    ! nkg̎ԍ
read(1, '(a)') line
read(1, *) bun      ! vZɂ鎞ԍ݂̕
read(1, '(a)') line
read(1, *) m        ! 
read(1, '(a)') line
read(1, *) h        ! 萔
read(1, '(a)') line
read(1, *) model    ! 𕜌̓f
read(1, '(a)') line
read(1, *) k1       ! 
read(1, '(a)') line
read(1, *) k2       ! ~̓񎟍
read(1, '(a)') line
read(1, *) yy       ! ~ϗ
close(1)

c = 2.d0 * h * sqrt(m * k1)  ! SW
dt = dtorg / bun             ! וꂽԍ
allocate( eq(n) )            ! z̓It  ͂nkg(galP)
allocate( tim(n) )           ! ȉCo͗p  Ԏ(s)
allocate( dis(n) )           ! Εψʉ(m)
allocate( vel(n) )           ! Αx(m/s)
allocate( acc(n) )           ! Ήx(m/s/s)
allocate( frc(n) )           ! (kN)
allocate( eqm(n) )           ! nkg(m/s/s)

! l
x = 0.d0        ! x:Εψ
v = 0.d0        ! v:Αx
a = 0.d0        ! a:Ήx
xold = 0.d0     ! xold:OXebv̕ψ
fold = 0.d0     ! fold:OXebv̕
xmax = yy / k1  ! 򉻃f̏ꍇ̍őŏψʂƍőŏ
xmin = -xmax
ymax = yy
ymin = -yy
dis = 0.d0      ! ۑpϐ̏
vel = 0.d0
acc = 0.d0
frc = 0.d0
eqm = 0.d0

! nkgǂݍ݁CPʂgalm/s/sɕϊ
open(1, file='eq.txt', status='old')
read(1, *) ( eq(i), i = 1, n )
do i = 1, n
  eq(i) = 1.d-2 * eq(i)
end do
close(1)

z0 = eq(1)
do i = 2, n
  z1 = eq(i)
  dz = ( z1 - z0 ) / dble( bun )      ! nkg̐`

  do j = 1, bun                       ! ԍ݂וČvZD܂ψxɑ΂镜f߂D
    if ( model == 1 ) then            ! `
      f = k1 * x
    else if ( model == 2 ) then       ! 򉻃Nt^
      f = clough(x, xold, yy, k1, xmax, xmin, fold, k2, ymax, ymin)
    else                              ! oCjA
      f = bilinear( x, xold, yy, k1, k2, fold )
    end if
    fold = f                          ! OXebv̒lۑĂD
    xold = x

    y11 = -(c * v + f) / m - z0       ! LQNb^@g1=f(y,t)
    y21 = v                           ! y_k1@k=1:x@k=2:x

    z0 = z0 + dz                      ! ͒nkg1Xebvi߂
    v2 = v + dt / 2.d0 * y11          ! g2=f(y+dt/2*g1,t+dt)vZ邽߁C
    x2 = x + dt / 2.d0 * y21          ! y+dt/2*g1̑xv2ƕψx2߂
    if ( model == 1 ) then            ! ψx2ɑ΂镜f߂
      f = k1 * x2
    else if ( model == 2 ) then
      f = clough(x2, xold, yy, k1, xmax, xmin, fold, k2, ymax, ymin)
    else
      f = bilinear( x2, xold, yy, k1, k2, fold )
    end if
    y12 = -(c * v2 + f) / m - z0      ! LQNb^@g2=f(y+dt/2*g1,t+dt)
    y22 = v2                          ! y_k2

    y13 = 2.d0 * y11 - y12            ! LQNb^@g3=2*g1-g2
    y23 = 2.d0 * y21 - y22            ! y_k3

    G11 = y11 * y11 + y21 * y21       !  G11=(g1,g1)
    G13 = y11 * y13 + y21 * y23       !  G13=(g1,g3)
    G33 = y13 * y13 + y23 * y23       !  G33=(g3,g3)

    if ( abs(G33) > EPS ) then        ! G33[̏ꍇ͒lXVȂD[łȂΌvZD
      v = v + dt * (2.d0 * y11 * G13 - y13 * G11) / G33      ! LQNb^@
      x = x + dt * (2.d0 * y21 * G13 - y23 * G11) / G33
    end if

    ! 򉻌^͂̌vZɕKvȍőEŏlXV
    if (x > xmax) then
     xmax = x
     ymax = f
    elseif (x < xmin) then
     xmin = x
     ymin = f
    end if
  end do    ! for j

  ! lۑ
  tim(i) = dtorg * i
  dis(i) = x
  vel(i) = v
  acc(i) = -(c * v + f) / m   ! Ήx=a+z^vZ
  frc(i) = f
  eqm(i) = z1
end do ! for i

! ʏo
open(1, file='output.txt', status='unknown')
write(1,'(11a)') 'Time (s)',tab,'Dis. (m)',tab,'Vel. (m/s)',tab, &
                 'Acc. (m/s/s)',tab,'Force (kN)',tab,'Ground Acc. (m/s/s)'
do i = 1, n
  write(1, '(f8.2,5(a,e14.7))') tim(i),tab,dis(i),tab,vel(i),tab,acc(i),tab,frc(i),tab,eqm(i)
end do
close(1)

open(1, file='results.txt', status='unknown')
write(1,'(a,f8.2,a)') 'Initial natural period : ', 2.d0 * PI / sqrt( k1 / m ), ' s'
write(1,'(a,f8.2,a)') 'Viscous damping coefficient : ', c, ' kNs/m'
write(1,'(a)') 'Maximum responses'
write(1,'(a,f8.2,a)') ' Displacement : ', max( maxval(dis), -minval(dis) ), ' m'
write(1,'(a,f8.2,a)') ' Velocity     : ', max( maxval(vel), -minval(vel) ), ' m/s'
write(1,'(a,f8.2,a)') ' Acceleration : ', max( maxval(acc), -minval(acc) ), ' m/s/s'
write(1,'(a,f8.2,a)') ' Force        : ', max( maxval(frc), -minval(frc) ), ' kN'
close(1)
write(*,*) 'Normal end.'

contains

!---------------------------
double precision function bilinear( x, xold, yy, k1, k2, yold )

! oCjA^
! x:ψ xold:OXebv̕ψ yy:~ϗ
! k1: k2:~̓񎟍 yold: OXebv̕
! l@http://www.ritsumei.ac.jp/se/rv/izuno/programming.html

double precision :: x, xold, yy, k1, k2, yold
double precision :: xy, yLinear, yPlus, yMinus

xy = yy / k1                       ! ~ψ
yLinear = k1 * (x - xold) + yold   ! OXebv̕ψʂ珉ŕωꍇ̕
yPlus = k2 * (x - xy) + yy         ! 񍄐Ō܂㑤̍iȐ̕
yMinus = k2 * (x + xy) - yy        ! 񍄐Ō܂鉺̍iȐ̕
bilinear = median( yLinear, yPlus, yMinus)   ! 3͂̒̕l߂鎟Xebv̕

end function bilinear

!---------------------------
double precision function clough( x, xold, yy, k1, xmax, xmin, yold, k2, ymax, ymin )

! 򉻃Nt^
! Clough, R.W. and Johnston, S.B.: Effect of stiffness degradation on earthquake ductility requirements,
! Proc. 2nd Japan Earthquake Engineering Symposium, pp. 227-232, 1966.
! ϐ̓oCjA^Ɠ̂ɉCɎ܂ł̍őŏlKvD
! xmax:őψ xmin:ŏψ ymax:ő啜 ymin:ŏ
! őŏl̏ĺC~̕ψʂƕ͂ĂD
! l@http://www.ritsumei.ac.jp/se/rv/izuno/programming.html

double precision :: x, xold, yy, k1, xmax, xmin, yold, k2, ymax, ymin
double precision :: fL , fp, fd, x0, xy, fplus, fminus, temp
double precision, parameter :: EPS = 0.0001  ! ̐ȏɉωΌvZ

xy = yy / k1
fL = k1 * (x - xold) + yold
x0 = xold - yold / k1
fplus = k2 * (x - xy) + yy
fminus = k2 * (x + xy) - yy
if (x > xold) then
 if ( abs(xmax - x0) < EPS ) then
  fp = yy
 else
  fp = (x - x0) * ymax / (xmax - x0)
 end if
 if ( abs(xmax - xold) < EPS ) then
  fd = yy
 else
  fd = (x - xold) * (ymax - yold) / (xmax - xold) + yold
 end if
 temp = median( fl, fp, fd )
 if ( fplus < temp ) then
  clough = fplus
 else
  clough = temp
 end if
else
 if ( abs(xmin - x0) < EPS ) then
  fp = -yy
 else
  fp = (x - x0) * ymin / (xmin - x0)
 end if
 if ( abs(xmin - xold) < EPS ) then
  fd = -yy
 else
  fd = (x - xold) * (ymin - yold) / (xmin - xold) + yold
 end if
 temp = median( fl, fp, fd )
 if ( fminus > temp ) then
  clough = fminus
 else
  clough = temp
 end if
end if

end function clough

!---------------------------
double precision function median( a, b, c )

! 3̐̒l߂

double precision :: a, b, c

if ( a >= b ) then
  if ( b >= c ) then
    median = b
  else if ( a <= c ) then
    median = a
  else
    median = c
  end if
else if ( a > c ) then
  median = a
else if ( b > c ) then
  median = c
else
  median = b
end if

end function median

end program response
