function video_file (time, x, y, filename)
    figure('position', [0, 0, 600, 600]);
    clf('reset');
    fr = 1;
    clear M;
    n = size(time,1);
    % 100個毎：0.001*100=0.1秒毎の
    for k=1:100:n
        clf;
        % [0;0] と [x(k);y(k)] を線分で結ぶ
        plot([0;x(k)], [0;y(k)], 'k-');
        xlim([-0.5,0.5]);
        ylim([-0.5,0.5]);
        xticks([-0.4:0.2:0.4]);
        yticks([-0.4:0.2:0.4]);
        pbaspect([1 1 1]);
        title(['time ' num2str(time(k),"%05.2f")]);
        grid on;
        M(fr) = getframe(gcf);
        fr = fr + 1;
    end
    M(fr) = getframe(gcf);
    
    v = VideoWriter(filename, 'MPEG-4');
    open(v);
    writeVideo(v, M);
    close(v);
end
