% `s̉ۂ𔻒
% `s Ax <= 0 ̉ x \neq 0 ۂ𔻒

function stat = non_zero_sol_homogeneous_ineqs (A)
    N = null(A);
    sz = size(N);
    if (sz(2) > 0)
        stat = 1;
        return;
    end
    
    sz = size(A);
    m = sz(1); % number of inequalities
    n = sz(2); % dimension
    I = eye(m);
    C = [ A, I;
        zeros(m,n), -I;
        zeros(1,n), ones(1,m) ];
    b = [ zeros(m,1); zeros(m,1); 1 ];
    f = [ zeros(n,1); -ones(m,1) ];
    x = linprog(f, C, b);
    if (f'*x < 0)
        stat = 1;
    else
        stat = 0;
    end
end
