% Ԃ𓙕ČvZ

xend = 10; yend = 3;

options = optimset('MaxFunEvals', 1e+6, 'MaxIter', 1e+5, 'TolFun',1e-10);

set(0,'defaultAxesFontSize',16);
set(0,'defaultTextFontSize',16);

% 5

n = 4;
h = xend/(n+1);
xnodal = transpose((1:n)*h);
ynodal = (yend/xend)*xnodal;
f = @(y) time_along_linear_approx_path( n, xnodal, y, xend, yend );
[yopt,fopt] = fminsearch(f, ynodal);
%n, fopt

xall = [0; xnodal; xend];
yall = [0; yopt;   yend];

plot(xall, yall);
set(gca,'YDir','reverse');
ylim([0,5]);
pbaspect([1 1/2 1]);
xlabel('x');
ylabel('y');
grid on;
saveas(gcf, 'fastest-10-3-linear-5.eps', 'eps');

fprintf("%d   %f\n", n+1, fopt);
fprintf("ꎞ~F̃L[Ă\n");
pause;

% 10

n = 9;
h = xend/(n+1);
xnodal = transpose((1:n)*h);
ynodal = (yend/xend)*xnodal;
f = @(y) time_along_linear_approx_path( n, xnodal, y, xend, yend );
[yopt,fopt] = fminsearch(f, ynodal);
%n, fopt

xall = [0; xnodal; xend];
yall = [0; yopt;   yend];

plot(xall, yall);
set(gca,'YDir','reverse');
ylim([0,5]);
pbaspect([1 1/2 1]);
xlabel('x');
ylabel('y');
grid on;
saveas(gcf, 'fastest-10-3-linear-10.eps', 'eps');

fprintf("%d   %f\n", n+1, fopt);
fprintf("ꎞ~F̃L[Ă\n");
pause;

% 20

n = 19;
h = xend/(n+1);
xnodal = transpose((1:n)*h);
ynodal = (yend/xend)*xnodal;
f = @(y) time_along_linear_approx_path( n, xnodal, y, xend, yend );
[yopt,fopt] = fminsearch(f, ynodal, options);
%n, fopt

xall = [0; xnodal; xend];
yall = [0; yopt;   yend];

plot(xall, yall);
set(gca,'YDir','reverse');
ylim([0,5]);
pbaspect([1 1/2 1]);
xlabel('x');
ylabel('y');
grid on;
saveas(gcf, 'fastest-10-3-linear-20.eps', 'eps');

fprintf("%d   %f\n", n+1, fopt);
fprintf("ꎞ~F̃L[Ă\n");
pause;
