% ŨOt

xinit = 2.00;
ratio = 0.01;
    
interval = 0:0.001:10;
qinit = [xinit;0.00];

hold on;

xlim([1,3]);
ylim([-0.04,0.04]);
xlabel('t');
ylabel('x');

b = 4;
vibration = @(t,q) damped_vibration_param (t,q,b);
[time,q4] = ode45(vibration,interval,qinit);

b = 4.9570;
vibration = @(t,q) damped_vibration_param (t,q,b);
[time,qopt] = ode45(vibration,interval,qinit);

b = 5;
vibration = @(t,q) damped_vibration_param (t,q,b);
[time,q5] = ode45(vibration,interval,qinit);

b = 6;
vibration = @(t,q) damped_vibration_param (t,q,b);
[time,q6] = ode45(vibration,interval,qinit);

%plot(time,q4(:,1), time,qopt(:,1), time,q5(:,1), time,q6(:,1));
%legend('4', '4.9570', '5', '6');
popt = plot(time,qopt(:,1),'k');
p5 = plot(time,q5(:,1),'--k');
p6 = plot(time,q6(:,1),'-.k');

sz = size(time);
limit = ratio*xinit*ones(sz);
plot(time, limit, 'k');
plot(time, -limit, 'k');

set(0,'defaultAxesFontSize',16);
set(0,'defaultTextFontSize',16);

legend([popt p5 p6], '4.9570', '5', '6');

saveas(gcf, 'damped_vibration_comparison.eps', 'eps');
